<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<?php
    $settings = App\Models\Layout::where('field', 'brand')->first()->config;
?>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title> 404 | الصفحة غير موجودة </title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.العودة للصفحة الرئيسية?family=Cairo:wght@200..1000&family=Tajawal:wght@200;300;400;500;700;800;900&display=swap"
        rel="stylesheet">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&family=Tajawal:wght@200;300;400;500;700;800;900&display=swap"
        rel="stylesheet">

</head>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    .tajawal-regular {
        font-family: "Tajawal", serif;
        font-weight: 400;
        font-style: normal;
    }


    body {
        font-family: 'Roboto', sans-serif;
        background: linear-gradient(to right,
                <?php echo e($settings['colors']['primary']); ?>

                ,
                <?php echo e($settings['colors']['secondary']); ?>

            );

        height: 100vh;
        color: #fff;
        overflow: hidden;
    }

    .container {
        padding-top: 50px;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .wrapper {
        text-align: center;
        background-color: rgba(255, 255, 255, 0.1);
        padding: 40px;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        backdrop-filter: blur(10px);
        animation: fadeIn 1.5s ease-out;
    }

    .error-box h1 {
        font-size: 6rem;
        font-weight: 700;
        margin-bottom: 10px;
        letter-spacing: 5px;
    }

    .error-box p {
        font-size: 1.3rem;
        margin-bottom: 20px;
        line-height: 1.5;
    }

    .home-btn {
        text-decoration: none;
        padding: 15px 25px;
        background-color: #ff6161;
        color: #fff;
        font-size: 1.2rem;
        border-radius: 10px;
        transition: all 0.3s ease;
        display: inline-block;
    }

    .home-btn:hover {
        background-color: #ff4040;
        transform: scale(1.1);
    }

    .home-btn:active {
        background-color: #e63535;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(50px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .logo {
        display: flex;
        justify-content: center;
        align-items: center;


    }

    .logo img {
        height: 100px;
        margin-top: 50px;
    }
</style>

<body dir="rtl" class="tajawal-regular ">
    <div class="container">
        <div class="wrapper">
            <div class="error-box">
                <h1>404</h1>
                <p>الصفحة التي تريد الوصول اليها غير موجودة</p>
                <a href="/" class="home-btn">العودة للصفحة الرئيسية</a>
            </div>
        </div>
    </div>
    <br>
    <div class="logo">
        <img src="<?php echo e(asset($settings['logo']['light'])); ?>" alt="logo">
    </div>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\sylearn\resources\views\errors\404.blade.php ENDPATH**/ ?>