import { string } from 'zod';
import { Link } from '../app';
import { Model } from './index';

export type Layout = Model & {
    field: string;
    config: LayoutConfig
};

export type LayoutConfig = Record<string, any> & {
    using_in: string[]
}

export type NavLayoutConfigProps =  {
    bg_color: string,
    menu: Link[],
    logo: {
        height?: number,
        width?: number
        mode: 'light'|'dark'|'color'|'normal'
    }
}
export type FooterLayoutConfigProps = {
    bg_color: string,
    menu: Link[],
    logo: {
        height?: number,
        width?: number
    },
    apps: (Link & { icon: string })[],
    socialMedia: (Link & { icon: string })[],
}

export type SectionLayoutConfigProps = {
    image: string
    title: string
    sub_title: string
    button: string
}

export type PagePublicLayoutConfigProps = {
    color: string
    bg: string
    bg_color: string
}


export type BrandLayoutConfigProps = {
    logo:{
        color:string
        dark:string
        light:string
    }
    color:{
        primary:string
        secondary:string
        gray:string
        thirdly:string
    }
}
