import { useFormProps } from '@/types/app'
import { Exam } from '@/types/models/exam'
import React, { FormEventHandler } from 'react'
import LectureSelect from './LectureSelect'
import { Lecture } from '@/types/models/lecture'
import { Divider } from 'antd'
import { PrimaryButton } from '@/Components'

type Props = {
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<Exam>
    lectures: Lecture[]
}

const ExamForm = ({ form, submit, lectures }: Props) => {
    return (
        <form className='flex flex-col gap-3' onSubmit={submit}>
            <Divider orientation="left" >معلومات الإمتحان</Divider>
            <LectureSelect lectures={lectures} selected={form.data.lecture_id} onSelect={s => form.setData('lecture_id', s)} />
            <PrimaryButton className='mt-5' >حفظ</PrimaryButton>

        </form>
    )
}

export default ExamForm
