import { ApplicationLogo } from '../../Components'
import { ensureHttpsUrl } from '../../Utils'
import { APP_URL } from '../../Constants'
import { BrandLayoutConfigProps, FooterLayoutConfigProps } from '@/types/models/layout'

type Props = {
    data?: FooterLayoutConfigProps
        brand?: BrandLayoutConfigProps

}

const PublicFooter = ({ data,brand }: Props) => {

    return (
        //${data?.bg_color}
        <footer className={`z-50  p-6`} style={{ background: data?.bg_color }}>
            <div className="container mx-auto ">
                <div>
                    {data?.logo && (
                        <ApplicationLogo src={brand?.logo.light} height={data?.logo.height} width={data?.logo.height} className={`h-[${data?.logo.height}px] object-contain`} />
                    )}
                </div>
                <div className="flex justify-between items-center">
                    {/* Menu Links */}
                    <div className="flex gap-4">
                        {data?.menu.map((link, index) => (
                            <a key={index} href={link.href} className="text-white hover:underline">
                                {link.text}
                            </a>
                        ))}
                    </div>

                    {/* Apps Links */}
                    <div className="flex gap-4">
                        {data?.apps.map((link, index) => (
                            <a key={index} href={link.href} className="text-white hover:underline">
                                <img height={"40px"} className='h-[40px] ' src={ensureHttpsUrl(link.icon, APP_URL)} alt="" />
                            </a>
                        ))}
                    </div>
                </div>
                {/* Social Media */}
                <div className="flex justify-between items-end">
                    <p className='text-white'>
                        &copy; {(new Date()).getFullYear()} all right reserved
                    </p>
                    <div className="flex gap-4 mt-10 justify-end">
                        {data?.socialMedia.map((link, index) => (
                            <a key={index} href={link.href} className="text-white hover:underline">
                                <img className='h-[30px] ' src={ensureHttpsUrl(link.icon, APP_URL)} alt="" />
                            </a>
                        ))}
                    </div>
                </div>

            </div>
        </footer>
    )
}

export default PublicFooter
