import { ApplicationLogo } from '@/Components'
import { APP_URL } from '@/Constants'
import { BrandLayoutConfigProps, Layout as  LayoutType, PagePublicLayoutConfigProps } from '@/types/models/layout'
import { ensureHttpsUrl } from '@/Utils'
import { Link, usePage } from '@inertiajs/react'
import {
    LayoutDashboard,
    Settings,
    Layout,
    BookOpen,
    ClipboardList,
    StickyNote,
    Users,
    UserCheck,
    Key,
    Shield,
    SignalMedium,
    Video
} from 'lucide-react'

type Props = {}

const DashboardSideBar = (props: Props) => {

    const layout = usePage().props.layout as LayoutType[]

    const brand = layout.find(l => l.field === 'brand')?.config as BrandLayoutConfigProps | undefined

    const page = layout.find(l => l.field === 'page_public')?.config as PagePublicLayoutConfigProps | undefined

    const menu = [
        {
            name: 'dashboard',
            text: 'لوحة القيادة',
            svg: <LayoutDashboard size={20} />
        },
        {
            name: 'settings',
            text: 'الإعدادات',
            svg: <Settings size={20} />
        },
        {
            name: 'layout',
            text: 'التخطيط',
            svg: <Layout size={20} />
        },
        {
            name: 'materials',
            text: 'المواد الدراسية',
            svg: <BookOpen size={20} />
        },
        {
            name: 'exams',
            text: 'الاختبارات',
            svg: <ClipboardList size={20} />
        },
        {
            name: 'notes',
            text: 'الملاحظات',
            svg: <StickyNote size={20} />
        },
        {
            name: 'users',
            text: 'المستخدمون',
            svg: <Users size={20} />
        },
        {
            name: 'teachers',
            text: 'المعلمون',
            svg: <UserCheck size={20} />
        },
        {
            name: 'levels',
            text: 'الصفوف',
            svg: <SignalMedium size={20} />
        },
        {
            name: 'videos',
            text: 'الفيديوهات',
            svg: <Video size={20} />
        },
        {
            name: 'roles',
            text: 'الأدوار',
            svg: <Key size={20} />
        },
        {
            name: 'permissions',
            text: 'الصلاحيات',
            svg: <Shield size={20} />
        }
    ];

    return (
        <aside
            id="default-sidebar"
            className="fixed top-0 right-0 z-40 w-64 h-screen transition-transform -translate-x-full sm:translate-x-0"
            aria-label="Sidebar"
        >
            <div className="h-full px-3 py-4 overflow-y-auto bg-gray-50 dark:bg-gray-900">
                <div className="flex items-center justify-center border-b mb-5 border-gray-500 pb-3">
                    <ApplicationLogo src={ensureHttpsUrl(brand?.logo.light,APP_URL)} className='h-12 ' />
                    <h3 className='text-white' ></h3>
                </div>
                <ul className="space-y-2 font-medium">
                    {menu.map((item, i) => <SidebarItem name={item.name} text={item.text} svg={item.svg} />)}
                </ul>
            </div>
        </aside>
    )
}

export default DashboardSideBar

interface SidebarItemProps {
    name: string;
    text: string;
    svg: React.ReactNode; // Pass the component, not props
    ntf?: string
}

const SidebarItem = ({ name, text, svg, ntf }: SidebarItemProps) => {
    return (
        <li>
            <Link
                href={route(`admin.${name}`)}
                className="flex  items-center p-2 text-gray-900 rounded-lg dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700 group"
            >
                {svg}
                <span className="ms-3 text-xs">{text}</span>
                <span className="inline-flex items-center justify-center px-2 ms-3 text-sm font-medium text-gray-800 bg-gray-100 rounded-full dark:bg-gray-700 dark:text-gray-300">
                    {ntf}
                </span>
            </Link>
        </li>
    );
};
