import { Play } from 'lucide-react'
import  { ButtonHTMLAttributes } from 'react'


const ButtonPlay = ({ ...props }: ButtonHTMLAttributes<HTMLButtonElement>) => {
    return (
        <button
            {...props}
            type="button"
            className="h-6 w-6  justify-center text-[12px] font-medium text-center inline-flex items-center text-white bg-purple-700 rounded-lg hover:bg-purple-800 focus:ring-4 focus:outline-none focus:ring-purple-300 dark:bg-purple-600 dark:hover:bg-purple-700 dark:focus:ring-purple-800"
        >
            <Play size={15} />
        </button>

    )
}

export default ButtonPlay
