import { Trash } from 'lucide-react'
import React, { ButtonHTMLAttributes } from 'react'

type Props = {}

const ButtonDelete = ({ ...props }: ButtonHTMLAttributes<HTMLButtonElement>) => {
    return (
        <button
            {...props}
            type="button"
            className="h-6 w-6  justify-center text-[12px] font-medium text-center inline-flex items-center text-white bg-red-700 rounded-lg hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800"
        >
            <Trash size={15} />
        </button>

    )
}

export default ButtonDelete
