import { Modal } from '@/Components'
import DashboardLayout from '@/Layouts/DashboardLayout'
import { ID } from '@/types/models'
import { Exam, ExamTask } from '@/types/models/exam'
import { Lecture } from '@/types/models/lecture'
import { ButtonAdd, ButtonDelete, ButtonEdit, ExamTaskForm } from '@/Ui'
import { useForm } from '@inertiajs/react'
import { Card } from 'antd'
import { Link } from 'lucide-react'
import { FormEventHandler, useState } from 'react'

type Props = {
    exam: Exam,
    lectures: Lecture[]

}

const ExamDetails = ({ exam, lectures }: Props) => {

    console.log(exam)

    const [modalOpen, setModalOpen] = useState<boolean>(false)
    const [modelSection, setModelSection] = useState('')

    const [selectedExamTask, setSelectedExamTask] = useState<ExamTask>()


    const handleAddExamTask = () => {
        setModalOpen(true)
        setSelectedExamTask(undefined)
        examTaskForm.setData(defaultExamTask)
        setModelSection('form')
    }

    const handleEditExamTask = (item:ExamTask) => {
        setModalOpen(true)
        setSelectedExamTask(item)
        examTaskForm.setData(item)
        setModelSection('form')
    }

    const handleDeleteExamTask = (item:ExamTask) => {
        setModalOpen(true)
        setSelectedExamTask(item)
        setModelSection('delete')
    }


    const defaultExamTask: ExamTask = {
        id: '',
        exam_id: exam.id,
        question: '',
        choices: [],
        answer: '',
        image: '',
        video_time: '00:00',
        points: 0,
    }

    const examTaskForm = useForm(selectedExamTask ?? defaultExamTask)

    const createExam: FormEventHandler = (e) => {
        e.preventDefault()
        examTaskForm.post(route('admin.examTask.createOne'), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }
    const updateExam: FormEventHandler = (e) => {
        e.preventDefault()
        examTaskForm.put(route('admin.examTask.updateOne', selectedExamTask?.id), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }

    const ExamTaskCard = ({ data }: { data: ExamTask }) => {
        return <Card className='mb-3' >
            <div className="flex justify-between">
                <h3 className='mb-3 font-semibold' >{data.question} </h3>
                <div className="flex flex-col gap-2">
                    <ButtonDelete onClick={()=>handleDeleteExamTask(data)} />
                    <ButtonEdit onClick={()=>handleEditExamTask(data)} />
                </div>
            </div>
        </Card>
    }


    return (
        <DashboardLayout title={'الاختبار: ' + exam.lecture?.title} headChild={<ButtonAdd text='إضافة سؤال' onClick={handleAddExamTask} />}>
            <Modal show={modalOpen} onClose={() => setModalOpen(false)}>
                {modelSection === 'form' && <ExamTaskForm form={examTaskForm} submit={selectedExamTask ? updateExam : createExam} />}
                {/* {(modelSection === 'delete' && selectedItem) && <DeleteForm show={modalOpen} id={selectedItem?.id} onClose={close} />} */}
            </Modal>
            {exam.tasks?.map((item, i) => (
                <ExamTaskCard data={item} />
            ))}
        </DashboardLayout>
    )
}

export default ExamDetails



