import { Head, usePage } from '@inertiajs/react';
import { PublicFooter, PublicNav } from '../Ui'
import { PropsWithChildren, ReactNode } from 'react';
import { BrandLayoutConfigProps, FooterLayoutConfigProps, Layout, NavLayoutConfigProps } from '../types/models/layout';

const PublicLayout = ({
    children,
    withFooter = true,
    withNav = true,
    title=''

}: PropsWithChildren<{ header?: ReactNode, withNav?: boolean, withFooter?: boolean ,title:string}>) => {

    const layout = usePage().props.layout as Layout[]

     const brand = layout.find(l=>l.field==='brand')?.config as BrandLayoutConfigProps|undefined

    const page = layout.find(l => l.field === 'page_public')?.config

    return (
        <div
            style={{
                color: page?.color,
                background: page?.bg_color,
                // backgroundImage: `url(${page?.bg})`,
                // backgroundSize: 'cover',
                // backgroundRepeat: 'no-repeat',
            }}>
                <Head title={title}/>
            <div className="">
                {withNav && <PublicNav brand={brand} data={layout.find(l => l.field === 'nav_public')?.config as NavLayoutConfigProps | undefined} />}
                <div className="min-h-screen p-4 md:8 lg:p-16">
                    {children}
                </div>
                {withFooter && <PublicFooter brand={brand} data={layout.find(l => l.field === 'footer_public')?.config as FooterLayoutConfigProps | undefined} />}
            </div>
        </div>
    )
}

export default PublicLayout
