import { APP_URL } from '@/Constants'
import { BrandLayoutConfigProps, Layout, PagePublicLayoutConfigProps } from '@/types/models/layout'
import { ensureHttpsUrl } from '@/Utils'
import { usePage } from '@inertiajs/react'
import { PropsWithChildren } from 'react'

const AuthAdminLayout = ({ children }: PropsWithChildren) => {

    const layout = usePage().props.layout as Layout[]

    const brand = layout.find(l => l.field === 'brand')?.config as BrandLayoutConfigProps | undefined

    const page = layout.find(l => l.field === 'page_public')?.config as PagePublicLayoutConfigProps | undefined

    return (
        <div className='flex justify-between items-center' >
            <div className={`h-screen w-full flex justify-center items-center`} style={{ background: page?.bg_color }}>
                <img className='h-24' src={ensureHttpsUrl(brand?.logo.light,APP_URL)} alt="" />
            </div>
            <div className="h-screen w-full flex justify-center items-center">
                <div className="w-full  p-24">
                    {children}
                </div>
            </div>
        </div>
    )
}

export default AuthAdminLayout
