import { usePage } from "@inertiajs/react";
import { Layout, PagePublicLayoutConfigProps, SectionLayoutConfigProps } from "../types/models/layout";

export const useLayout = (section:string) => {

    const layout = usePage().props.layout as Layout[];

    return layout.find(m => m.field === 'home_page')?.config[section] as SectionLayoutConfigProps | undefined
}

export const usePagePublicLayout = () => {

    const layout = usePage().props.layout as Layout[];

    return layout.find(m => m.field === 'page_public')?.config.page_public as PagePublicLayoutConfigProps | undefined
}
