import React from "react";

interface ColorizeLogoProps {
  src: string;
  color: string; // Accepts HEX or RGB (e.g., "#ff0000" or "rgb(255, 0, 0)")
  width?: number | string;
  height?: number | string;
}

const ColorizeLogo: React.FC<ColorizeLogoProps> = ({ src, color, width = "100px", height = "100px" }) => {
  return (
    <div
      style={{
        position: "relative",
        width,
        height,
        display: "inline-block",
      }}
    >
      {/* Original Logo */}
      <img
        src={src}
        alt="Logo"
        style={{
          width: "100%",
          height: "100%",
          filter: "brightness(0) invert(1)", // Make the logo white
        }}
      />
      {/* Color Overlay */}
      <div
        style={{
          position: "absolute",
          top: 0,
          left: 0,
          width: "100%",
          height: "100%",
          backgroundColor: color,
          mixBlendMode: "multiply", // Blend the color with the image
        }}
      />
    </div>
  );
};

export default ColorizeLogo;
