import React, { useState } from 'react'
import FormUpload from './FormUpload'
import { ButtonDelete } from '@/Ui'
import FormElement from './FormElement'
import { ensureHttpsUrl } from '@/Utils'
import { APP_URL } from '@/Constants'
import FormInput from './FormInput'

type Props = {
    image?: string
    name?:string
    onSuccess?: ((response: ApiResponseProps) => void)
}

type ApiResponseProps = {
    file_path:string
}

const ImageOrUpload = ({ image,name, onSuccess }: Props) => {

    const [remove, setRemove] = useState(false)
    const [uploaded, setUploaded] = useState(image)

    return (
        <FormElement label='الصورة' className='my-3'>
            {uploaded && !remove && <>
                <img src={ensureHttpsUrl(uploaded,APP_URL)} alt="image" className="max-w-[200px] max-h-[200px] object-contain m-3 " />
                <FormInput label='' value={uploaded} type='hidden' name={name ?? 'image'} />
                <ButtonDelete className='mt-2' onClick={() => setRemove(true)} />
            </>}
            {(!uploaded || remove) && <FormUpload type='image' onSuccess={(res)=>{
                setUploaded(res.file_path)
              if(onSuccess)  onSuccess(res)
            }} />}
        </FormElement>
    )
}

export default ImageOrUpload
