import { InputHTMLAttributes } from 'react'
import TextInput from './TextInput'
import FormElement from './FormElement'

type Props = InputHTMLAttributes<HTMLTextAreaElement> & {
    label?: string
    error?: string
    labelClassName?: string
}

const FormInput = ({ label, labelClassName, error, ...props }: Props) => {
    return (
        <FormElement error={error} label={label} labelClassName={labelClassName}>
            <textarea className={'rounded-md border-gray-300 shadow-sm w-full focus:border-indigo-500 focus:ring-indigo-500 ' + props.className} {...props} rows={5} >
                {props.value}
            </textarea>
        </FormElement>
    )
}

export default FormInput
