<?php

namespace Database\Seeders;

use App\Models\Teacher;
use App\Models\User;
use App\Services\Model\UserService;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class TeacherSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::where(['name' => 'abdullah-alsubie'])->first()?->delete();
        $user = User::create([
            'name' => 'abdullah-alsubie',
            'first_name' => 'Abdullah',
            'last_name' => 'Alsubie',
            'phone' => '053212565884',
            'email' => 'abdullah.alsubie@gmail.com',
            'password' => Hash::make('123456789'),
            'api_token' => Hash::make(value: 'token'),
        ]);
        (new UserService($user))->createTeacher();
    }
}
