<?php

namespace Database\Seeders;

use App\Models\Legal;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class LegalSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'type' => 'terms_conditions',
                'title' => 'تمهيد',
                'content' => ' تعريف منصة عُلا

في هذه الشروط تشير كل ضمائر المتكلم الجمع وكل ما يعود إليها "نحن/لنا/بنا" إلى منصة عُلا (واسمها التجاري هو شركة علا التكنلوجية العالمية لتصميم وإدارة مواقع الانترنت) والذي يقع مكتبها المسجل في العنوان - القبلة - قطعة 13 شارع سور برج الناصر هي منصة تعمل لنقل محتوى مسجل ومواد تعليمية للمستخدمين الذين يسجلون في التطبيق أو في خدمة الموقع الالكتروني لمحتوى المستخدم ومحتوى منصة عُلا. ',
            ],
            [
                'type' => 'terms_conditions',
                'title' => 'تعريف المعلم',
                'content' => 'المعلمون هم المدرسون الذين يظهرون في المادة المسجلة وبالتعليقات ',
            ],
            [
                'type' => 'terms_conditions',
                'title' => 'تعريف المستخدم',
                'content' => 'المستخدمون هم جميع الأفراد الذين يسجلون في التطبيق أو في خدمة الموقع الالكتروني.',
            ],
            [
                'type' => 'terms_conditions',
                'title' => ' الأهلية ',
                'content' => 'قبول الشروط عند الدخول يقر المستخدم بأن لديه مهلة للاطلاع على هذه البنود وأنه يفهم أن استخدامه للخدمة يخضع لأحدث نسخة من هذه البنود.

نقدم هذه البنود والشروط مع منصة عُلا لذلك فان المستخدم يعلم ما هي البنود المطبقة لاستخدامه للمنصة. وأنه يقر بأننا منحناه فرصة معقولة للاطلاع على هذه البنود والشروط وأنه يوافق عليها ويوافق ويقر بأن استخدامه لمنصة عُلا يخضع لأحدث نسخة من البنود والشروط المتاحة على منصة عُلا عند استخدامه لها. ',
            ],
            [
                'type' => 'terms_conditions',
                'title' => 'المستخدمون المحظورون',
                'content' => 'لموقع غير متاح لأي مستخدم محظور

أهلية الحسابات: الموقع غير متاح للفئات الاتية

لأي مستخدم قد يتم تعليق حسابه سابقاً أو أزيل من الموقع الإلكتروني بواسطة (منصة عُلا)

أي شخص تحت سن 21 عاماً والذي لم يتم الموافقة على تسجيله من قبل ولي أمره أو الوصي عليه (أو من قبل حسابات المدارس عن طريق موظفين المدرسة حسب ما هو مسموح بموجب الشروط). ',
            ],
            [
                'type' => 'privacy_policy',
                'title' => '',
                'content' => 'نحن في شركة علا التكنلوجية العالمية لتصميم وإدارة مواقع الانترنت ("علا" "نحن") نحترم خصوصيتك ونريدك أن تفهم كيف نجمع ونستخدم ونشارك بياناتك.

تغطي سياسة الخصوصية هذه ممارسات جمع المعلومات وتصف حقوقك للوصول إلى معلوماتك الشخصية أو الاستخدام السليم لها أو القيود عليها.

ومالم نربط سياسة أخرى أو ينص خلاف ذلك، فإن سياسة الخصوصية هذه تستخدم عند زيارة أو استخدام الموقع الإلكتروني لعٌلا أو التطبيقات الإلكترونية أو واجهة برمجة التطبيقات الخاصة بها أو الخدمات المرتبطة بها وعبر اي خدمة تواصل اخرى لديك معنا.

عند استخدامك للخدمات، فأنت توافق على بنود هذه الإتفاقية، وينبغي عليك عدم استخدام الخدمات إذا لم توافق على سياسة الخصوصية هذه أو أي اتفاق آخر يحكم استخدامك للخدمات.

نستخدم البيانات الخاصة بك لتزويد وتحسين الخدمة. في كل وقت تقوم بالوصول او استخدام الخدمة او تزويدنا بالمعلومات، وبالقيام بهذا فانه بمثابة موافقة وقبول للممارسات المنصوص عليها بسياسة الخصوصية تلك. ما لم يرد خلاف ذلك طي سياسة الخصوصية، الاحكام المستخدمة بسياسة الخصوصية لها نفس المعاني والدلالة طبقاً لما ورد بالأحكام والشروط وبالموافقة عليه فهو بمثابة القبول والموافقة على سياسة الخصوصية',
            ],
            [
                'type' => 'privacy_policy',
                'title' => 'ما البيانات التي نحصل عليها',
                'content' => 'اثناء استخدام خدماتنا، قد نطلب منك تزويدنا بمعلومات معينة لتحديد الهوية الشخصية التي يمكن استخدامها للتواصل أو التعرف عليك ("البيانات الشخصية"). نجمع البيانات منك بصورة مباشرة، هذه البيانات مثل: معلومات عن دخولك وبيانات عن مشاركتك في الدورات وبيانات من منصات أخرى ترتبط مع تطبيق عُلا. أيضاً نجمع بعض المعلومات بصورة تلقائية، مثل المعلومات عن جهازك وماهي أجزاء خدماتنا التي تتفاعل معها أو الوقت الذي تقضيه في استخدام البيانات.',
            ],
            [
                'type' => 'privacy_policy',
                'title' => 'بيانات تقدمها لنا ',
                'content' => 'قد نجمع بيانات مختلفة منك أو عنك تعتمد على كيفية استخدامك للخدمات. وفيما يلي أدناه بعض الأمثلة تساعدك لفهم أفضل عن البيانات التي نجمعها.

عندما تنشأ حساباً وتستخدم الخدمات، بما في ذلك منصة خارجية، فإننا نجمع أي بيانات تقدمها بصورة مباشرة، وتتضمن ولا تنحصر فيما يلي:',
            ],
            [
                'type' => 'privacy_policy',
                'title' => 'بيانات الحساب ',
                'content' => 'ولكي يتم استخدام بعض الخصائص (على سبيل المثال: التسجيل في دورة ما)، فأنت بحاجة إلى إنشاء حساب مستخدم، وعند إنشاء أو تحديث حسابك، فإننا نجمع ونخزن البيانات التي تسجلها مثل: البريد الإلكتروني والرقم السري ورقم الهاتف والمهنة والاهتمام بالمهارات والجنس والعرق ومعلومات الهوية الشخصية والتحقق من الصورة والعمر وتاريخ الميلاد وتحديد الرقم الموحد ("بيانات الحساب").',
            ],
            [
                'type' => 'privacy_policy',
                'title' => 'بيانات الملف الشخصي',
                'content' => 'أيضاً يمكنك اختيار تقديم معلومات الملف الشخصي مثل: الصورة، أو العنوان، أو السيرة الذاتية، أو اللغة، أو رابط الموقع الإلكتروني، أو ملف وسائل التواصل الاجتماعي أو الدولة أو بيانات أخرى (" بيانات الملف الشخصي")، ويمكن مشاهدة بيانات ملفك الشخصي من قبل العامة.',
            ],
            [
                'type' => 'privacy_policy',
                'title' => 'المحتوى الذي يتم مشاركته',
                'content' => 'إن أجزاء الخدمات تمكنك من التفاعل مع المستخدمين الآخرين أو مشاركة محتوى للعامة، وذلك يشمل نشر استعراض عن صفحة الدورة أو طلب سؤال أو إجابة عن أسئلة أو إرسال رسائل إلى الطلاب والمعلمين أو نشر صور أو عمل آخر تقوم بتحميله. فمثل هذا المحتوى الذي يتم مشاركته قد يكون مرئي للعموم، اعتماداً على أين تم نشره.',
            ],
            [
                'type' => 'privacy_policy',
                'title' => 'بيانات الدورة ',
                'content' => 'عندما تسجل في الدورات، فإننا نجمع بعض البيانات مثل: ما هي الدورات والتكليفات والاختبارات التي بدأتها وأنجزتها وحواراتك مع المعملين ومساعدي المعلمين والطلاب الآخرين والمقالات والإجابات على الأسئلة والبنود الأخرى المقدمة للوفاء بمتطلبات الدورة.',
            ],
            [
                'type' => 'privacy_policy',
                'title' => 'بيانات مدفوعات الطالب ',
                'content' => 'إذا قمت بإجراء مشتريات، فإننا نجمع بعض البيانات عن مشترياتك (مثل اسمك والرمز البريدي) حسب الضرورة لتنفيذ طلبك. عليك بتقديم بعض بيانات الدفع والفوترة مباشرة لشركائنا في معالجة عملية الدفع، وذلك يتضمن: الاسم ومعلومات البطاقة الائتمانية، وعنوان الفوترة، والرمز البريدي. ولأمور أمنية، لا تجمع عٌلا أو تخزن البيانات الحساسة لحامل البطاقة (مثل: الأرقام الكاملة للبطاقة الائتمانية أو بيانات توثيق البطاقة) المعلومات المتحصل عليها لهذا الغرض تُقدم مباشرة الى معالجات الدفع للطرف الاخر الخاص بنا والذي يستخدم معلوماتك الشخصية التي تحكمها سياسة الطرف الآخر.',
            ],
        ];


        Legal::truncate();

        foreach ($data as $i => $item) {
            Legal::create([
                'number' => $i+1,
                ...$item
            ]);
        }
    }
}
