<?php

namespace App\Services\ThirdParty;

use App\Contracts\OtpSenderInterface;

class FakeOtpSender implements OtpSenderInterface
{
    protected string $to;

    public function send($otp): bool
    {
        $path = storage_path('data/otp.txt');
        return (bool) file_put_contents($path, $otp);
    }

    public function setTo(string $phone): self
    {
        $this->to = $phone;
        return $this;
    }
}
