<?php

namespace App\Services\Model;

use App\Enums\UserTypeEnum;
use App\Models\Student;
use App\Models\Teacher;
use App\Models\User;
use Illuminate\Http\Request;

class UserService
{

    public function __construct(protected User $user)
    {
        //
    }

    public function setUser(User $user)
    {
        $this->user = $user;
        return $this;
    }

    public function createStudent()
    {
        $student = new Student();
        $student->fill([
            'user_id' => $this->user->id,
            'is_active' => true,
        ]);
        return $student->save();
    }

    public function createTeacher(string $bio = '', array $tags = [], ?string $image = null)
    {
        $teacher = new Teacher();
        $teacher->fill([
            'user_id' => $this->user->id,
            'is_active' => true,
            'tags' => $tags,
            'bio' => $bio,
            'image' => $image ?? '/media/images/icon/teacher.png',
        ]);
        return $teacher->save();
    }

    public static function createUserFromRequest(Request $request, UserTypeEnum $type)
    {
        return User::create([
            'email' => $request->email,
            'password' => bcrypt($request->password),
            'name' => $request->name,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'phone' => $request->phone,
            'type'=>$type
        ]);
    }
}
