<?php

namespace App\Services\Model;

use App\Models\Level;
use App\Models\Student;
use App\Models\StudentProcessCourse;
use App\Models\SubLevel;
use Illuminate\Support\Facades\Auth;

class StudentService
{

    public function __construct(protected Student $student)
    {
        //
    }

    /**
     *  change student Level
     * @param  \Illuminate\Database\Eloquent\Collection<int, \App\Models\Level>  $level
     * @param \Illuminate\Database\Eloquent\Collection<int, \App\Models\SubLevel> $subLevel
     * @return bool
     */
    public function changeLevel( $level, $subLevel = null): bool
    {

        $this->student->level_id = $level->id;
        if ($subLevel) {
            $this->student->sub_level_id = $subLevel->id;
        }

        return $this->student->save();
    }

    public function student(?array $with = null)
    {
        return Student::with($with ?? [
            'level.materials',
            'level.subLevels',
            'subLevel',
            'studentProcess',
            'exams',
            'lectureQuestions',
        ])->where(['user_id' => Auth::id()])->first();
    }
}
