<?php

namespace App\Providers;

use App\Models\Admin;
use App\Services\Model\AdminService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;

class AdminProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(AdminService::class, function ($app) {
            $with = [

            ];

            $admin = Admin::with($with)->where(['user_id' => Auth::id()])->first();

            if ($admin) {
                return new AdminService($admin);
            }

            return null;
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
