<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Video extends Model
{
    /** @use HasFactory<\Database\Factories\VideoFactory> */
    use HasFactory;

    protected $fillable = [
        'file',
        'subtitle_file',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function lecture()
    {
        return $this->hasOne(Lecture::class);
    }
}
