<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Teacher extends Model
{
    /** @use HasFactory<\Database\Factories\TeacherFactory> */
    use HasFactory;

    protected $fillable = [
        'user_id',
        'tags',
        'bio',
        'image',
    ];

    protected $casts = [
        'tags' => 'array', // Cast 'tags' as an array
        'user_id' => 'integer',
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function studentProcessCourses()
    {
        return $this->hasMany(StudentProcessCourse::class);
    }

    public function lectures()
    {
        return $this->hasMany(Lecture::class);
    }
}
