<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    /** @use HasFactory<\Database\Factories\SettingFactory> */
    use HasFactory;

    protected $fillable = [
        'field',
        'config',
        'batch',
    ];

    protected $casts = [
        'field' => 'string',
        'config' => 'array', // Casting to an array as it is a JSON column
        'batch' => 'string',
    ];
}
