<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LectureReview extends Model
{
    /** @use HasFactory<\Database\Factories\LectureReviewFactory> */
    use HasFactory;

    protected $fillable = [
        'student_id',
        'lecture_id',
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function lecture()
    {
        return $this->belongsTo(Lecture::class);
    }
}
