<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lecture extends Model
{
    /** @use HasFactory<\Database\Factories\LectureFactory> */
    use HasFactory;

    protected $fillable = [
        'course_id',
        'course_section_id',
        'teacher_id',
        'video_id',
        'title',
        'description',
        'time',
        'number',
        'is_active',
    ];

    protected $casts = [
        'course_id' => 'integer',
        'course_section_id' => 'integer',
        'teacher_id' => 'integer',
        'video_id' => 'integer',
        'title' => 'string',
        'description' => 'string', // Assuming description is text
        'time' => 'string', // Assuming time is stored as a string (e.g., "2:30 PM")
        'number' => 'integer',
        'is_active' => 'boolean',
    ];

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function courseSection()
    {
        return $this->belongsTo(CourseSection::class, 'course_section_id');
    }

    public function teacher()
    {
        return $this->belongsTo(Teacher::class);
    }

    public function video()
    {
        return $this->belongsTo(Video::class);
    }

    public function exam()
    {
        return $this->hasOne(Exam::class);
    }

    public function reviews()
    {
        return $this->hasMany(LectureReview::class);
    }

    public function questions()
    {
        return $this->hasMany(LectureQuestion::class);
    }
}
