<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    /** @use HasFactory<\Database\Factories\CourseFactory> */
    use HasFactory;

    protected $fillable = [
        'material_id',
        'title',
        'description',
        'number',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }

    public function material()
    {
        return $this->belongsTo(Material::class);
    }

    public function sections()
    {
        return $this->hasMany(CourseSection::class);
    }

    public function scopeSortByNumber($query)
    {
        return $query->orderBy('number');
    }
}
