<?php

namespace App\Http\Requests\ExamTask;

use Illuminate\Foundation\Http\FormRequest;

class CreateExamTaskRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'exam_id'=>'required|exists:exams,id',
            'question'=>'required|string',
            'choices'=>'required|array',
            'choices.*'=>'string',
            'answer'=>'required|string',
            'image'=>'nullable|string',
            'video_time'=>'nullable|string',
            'points'=>'required|integer',
        ];
    }
}
