<?php

namespace App\Http\Middleware\View;

use App\Enums\UserTypeEnum;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (in_array(auth()->user()->type, [UserTypeEnum::ADMIN, UserTypeEnum::SUPER_ADMIN])) {
            abort(403);
        }
        return $next($request);
    }
}
