<?php

namespace App\Http\Middleware;

use App\Models\Layout;
use App\Services\Model\StudentService;
use Illuminate\Http\Request;
use Inertia\Middleware;

class HandleInertiaRequests extends Middleware
{

    public function __construct(protected ?StudentService $studentService) {}

    /**
     * The root template that is loaded on the first page visit.
     *
     * @var string
     */
    protected $rootView = 'app';

    /**
     * Determine the current asset version.
     */
    public function version(Request $request): ?string
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     *
     * @return array<string, mixed>
     */
    public function share(Request $request): array
    {
        $routePrefix = $request->route() ? $request->route()->getPrefix() : null;

        return [
            ...parent::share($request),
            'auth' => [
                'user' => $request->user(),
                'student' => $this->studentService?->student()
            ],
            'flash' => [
                'status' => fn() => $request->session()->get('status'),
                'message' => fn() => $request->session()->get('message'),
            ],
            'layout' => Layout::all()
        ];
    }
}
//filterByUsingIn($routePrefix)
