<?php

namespace App\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class RestApiController extends Controller
{
    public function successResponse($data, $message = null, $code = 200)
    {
        $dataResponse = [
            'status' => 'success',
        ];

        if ($message) {
            $dataResponse['message'] = $message;
        }

        if ($data) {
            $dataResponse['data'] = $data;
        }

        return response()->json($dataResponse, $code);
    }

    public function errorResponse($message, $code): JsonResponse
    {
        return response()->json([
            'status' => 'error',
            'message' => $message
        ], $code);
    }

    public function notFoundResponse($message = 'Resource not found')
    {
        return $this->errorResponse($message, 404);
    }

    public function badRequestResponse($message = 'Bad request')
    {
        return $this->errorResponse($message, 400);
    }

    public function unauthorizedResponse($message = 'Unauthorized')
    {
        return $this->errorResponse($message, 401);
    }

    public function forbiddenResponse($message = 'Forbidden')
    {
        return $this->errorResponse($message, 403);
    }

    public function internalServerErrorResponse($message = 'Internal server error')
    {
        return $this->errorResponse($message, 500);
    }

    public function validationErrorResponse($errors)
    {
        return response()->json([
            'status' => 'error',
            'errors' => $errors
        ], 422);
    }
}
