<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Http\Controllers\Controller;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\ModelGetExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\RestApiController;
use App\Http\Requests\User\CreateUserRequest;
use App\Http\Requests\User\UpdateUserRequest;

class UserController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: [

        ])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse($this->model::with(relations:[

        ])->findOrFail($id));
    }

    public function createOne(CreateUserRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'User created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create User');
    }

    public function updateOne(UpdateUserRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'User updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update User');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'User deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete User');
    }
}
