<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Http\Controllers\RestApiController;
use App\Models\Layout;
use App\Models\Legal;
use App\Models\Setting;


class PublicController extends RestApiController
{

    public function settings()
    {
        return $this->successResponse(Setting::all());
    }
    public function layout()
    {
        return $this->successResponse(Layout::all());
    }
    public function termsAndConditions()
    {
        return $this->successResponse(Legal::where(['type' => 'terms_conditions'])->orderBy('number')->get());
    }

    public function privacyPolicies()
    {
        return $this->successResponse(Legal::where(['type' => 'privacy_policy'])->orderBy('number')->get());
    }
}
