<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Http\Controllers\Controller;
use App\Extensions\Controller\ModelGetExtension;
use App\Http\Controllers\RestApiController;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Requests\Material\CreateMaterialRequest;
use App\Http\Requests\Material\UpdateMaterialRequest;
use App\Models\Material;

class MaterialController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse(Material::with(relations: ['courses','subLevel','level'])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse(Material::with(relations:['courses','subLevel','level'])->findOrFail($id));
    }

    public function createOne(CreateMaterialRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'Material created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create Material');
    }

    public function updateOne(UpdateMaterialRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'Material updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update Material');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'Material deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete Material');
    }
}
