<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\ModelGetExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\RestApiController;
use App\Http\Requests\Level\CreateLevelRequest;
use App\Http\Requests\Level\UpdateLevelRequest;

class LevelController extends RestApiController
{

    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: [
            'subLevels',
            'materials',
            'students',
        ])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse($this->model::with(relations:[
            'subLevels',
            'materials',
            'students',
        ])->findOrFail($id));
    }

    public function createOne(CreateLevelRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'Level created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create Level');
    }

    public function updateOne(UpdateLevelRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'Level updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update Level');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'Level deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete Level');
    }
}
