<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Extensions\Controller\ModelGetExtension;
use App\Http\Controllers\RestApiController;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Requests\Exam\CreateExamRequest;
use App\Http\Requests\Exam\UpdateExamRequest;
use App\Models\Exam;
use Illuminate\Http\Request;

class ExamController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse(Exam::with(relations: ['lecture','tasks'])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse(Exam::with(relations: ['lecture','tasks'])->findOrFail($id));
    }

    public function createOne(CreateExamRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'Exam created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create exam');
    }

    public function updateOne(UpdateExamRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'Exam updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update exam');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'Exam deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete exam');
    }
}
