<?php

namespace App\Http\Controllers\RestApi\V1;

use Illuminate\Http\Request;
use App\Extensions\Controller\ModelGetExtension;
use App\Http\Controllers\RestApiController;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Requests\CourseSection\CreateCourseSectionRequest;
use App\Http\Requests\CourseSection\UpdateCourseSectionRequest;

class CourseSectionController extends RestApiController
{

    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: ['course','lectures'])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse($this->model::with(relations:['course','lectures'])->findOrFail($id));
    }

    public function createOne(CreateCourseSectionRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'CourseSection created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create CourseSection');
    }

    public function updateOne(UpdateCourseSectionRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'CourseSection updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update CourseSection');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'CourseSection deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete CourseSection');
    }
}
