<?php

namespace App\Http\Controllers\Core;

use App\Enums\UserTypeEnum;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\Teacher\CreateTeacherRequest;
use App\Http\Requests\Teacher\UpdateTeacherRequest;
use App\Models\User;
use App\Services\Model\UserService;
use Illuminate\Http\Request;

class TeacherController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateTeacherRequest $request)
    {
        $request->validated();

        UserService::createUserFromRequest($request, UserTypeEnum::TEACHER);

        if ($this->create($request, [
            'user_id' => User::where('email', $request->email)->first()->id,
            'tags' => []
        ])) {
            return $this->redirectWithNotification(
                redirect()->route('admin.teachers'),
                'success',
                'Teacher created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create teacher');
    }

    public function updateOne(UpdateTeacherRequest $request, $id)
    {
        if ($this->update($request, $id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.teachers'),
                'success',
                'Teacher updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update teacher');
    }

    public function deleteOne($id)
    {
        if ($this->delete($id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.teachers'),
                'success',
                'Teacher deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete teacher');
    }
}
