<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\Role\CreateRoleRequest;
use App\Http\Requests\Role\UpdateRoleRequest;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Http\Request;

class RoleController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateRoleRequest $request)
    {
        if (
            $this->create($request, [])
        ) {
            if ($request->permissionsIDs)
                $this->modelCreated->givePermissionTo(
                    Permission::findMany($request->permissionsIDs)
                );

            return $this->redirectWithNotification(
                redirect()->route('admin.roles', ['id' => $request->material_id]),
                'success',
                'Role created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create Role');
    }

    public function updateOne(UpdateRoleRequest $request, $id)
    {
        if ($this->update($request, $id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.roles', ['id' => $request->material_id]),
                'success',
                'Role updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update Role');
    }

    public function deleteOne($id)
    {
        if ($this->delete($id)) {
            return $this->redirectWithNotification(
                back(),
                'success',
                'Role deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete Role');
    }

    public function givePermissionTo($roleId, $permissionId)
    {
        $role = Role::findOrFail($roleId);
        $permission = Permission::findOrFail($permissionId);

        $$role->givePermissionTo($permission);

        return $this->redirectWithNotification(back(), 'Permission give to role', 'success');
    }
}
