<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\Material\CreateMaterialRequest;
use App\Http\Requests\Material\UpdateMaterialRequest;
use Illuminate\Http\Request;

class MaterialController extends CoreController
{

    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;


    public function __construct() {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateMaterialRequest $request)
    {
        if($this->create($request)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.materials'), 'success', 'Material created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create material');
    }


    public function updateOne(UpdateMaterialRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.materials'), 'success', 'Material updated successfully'
            );
        }
        return $this->redirectWithNotification(back(), 'error', 'Failed to update material');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.materials'), 'success', 'Material deleted successfully'
            );
        }
        return $this->redirectWithNotification(back(), 'error', 'Failed to delete material');
    }
}
