<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\CourseNote\CreateCourseNoteRequest;
use App\Http\Requests\CourseNote\UpdateCourseNoteRequest;
use Illuminate\Http\Request;

class CourseNoteController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct() {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateCourseNoteRequest $request)
    {
        if($this->create($request)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.notes'), 'success', 'CourseNote created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create course_note');
    }

    public function updateOne(UpdateCourseNoteRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.notes'), 'success', 'CourseNote updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update course_note');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.notes'), 'success', 'CourseNote deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete course_note');
    }
}
