<?php

namespace App\Http\Controllers\Auth;

use App\Contracts\OtpSenderInterface;
use App\Enums\UserTypeEnum;
use App\Http\Controllers\ViewController;
use App\Http\Requests\Auth\LoginRequest;
use App\Models\User;
use App\Services\ThirdParty\FakeOtpSender;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use App\Services\Model\UserService;
use App\Utils\Otp;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use Inertia\Response;

class AuthAdminController {

    public function login(LoginRequest $request): RedirectResponse
    {
        $request->authenticate();

        $request->session()->regenerate();

        return redirect()->intended(route('admin.dashboard', absolute: false));
    }

    public function logout(Request $request)
    {
        dd('m');
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect(route('admin.login'));
    }
}
