<?php

namespace App\Extensions\Controller;

use Closure;
use Illuminate\Http\Request;

trait UpdateExtension
{
    // public function updateOne($id, $data)
    // {
    //     return $this->update($id, $data);
    // }
    protected $modelUpdated = null;

    public function updateMany($data)
    {
        $response = [];
        foreach ($data as $item) {
            $response[] = $this->update($item['id'], $item);
        }
        return $response;
    }

    private function update(Request $request, $id, ?Closure $onFinish = null): bool
    {
        $model = $this->model;
        $model = $model::find($id);
        if(!$model){
            return false;
        }
        $result =   $model->update($request->validated());

        if($result){
            $this->modelUpdated = $model;
        }

        if ($onFinish) {
            $onFinish($model);
        }
        return $result;
    }
}
