<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class MakeExtension extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:ext {name} ';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new extension class in the app/Extensions directory';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $name = $this->argument('name');

        Artisan::call("make:trait Extensions/{$name}Extension");
    }
}
