<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class MakeCoreModel extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:core-model {name}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a model with migration, factory, and a controller under Core';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $name = $this->argument('name');

        // Create model with migration and factory
        Artisan::call("make:model {$name} -m -f");

        // Create controller in Core folder
        Artisan::call("make:controller Core/{$name}Controller");

        $this->info("Model, migration, factory, and controller created successfully!");
    }
}
