<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class CreateViewController extends Command
{
     /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:view-controller {name}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create view controller';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $name = $this->argument('name');

        $name = ucfirst($name);

        Artisan::call("make:controller View/{$name}Controller");

        $this->info("controller Request created successfully!");
    }
}
